/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.domain;

import eu.europa.ec.taxud.cesop.domain.ValidationErrorType;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ValidationErrorTypeHolder {
    public static final ValidationErrorTypeHolder INSTANCE = new ValidationErrorTypeHolder();
    private final List<ValidationErrorType> dataList = new ArrayList<ValidationErrorType>();
    private final Map<String, ValidationErrorType> mapByCode = new HashMap<String, ValidationErrorType>();
    private final Map<String, ValidationErrorTypeEnum> enumByCode = new HashMap<String, ValidationErrorTypeEnum>();

    public void setDataList(List<ValidationErrorType> dataList) {
        this.dataList.clear();
        this.dataList.addAll(dataList);
        this.initializeCodeMap();
    }

    private void initializeCodeMap() {
        this.mapByCode.clear();
        for (ValidationErrorType errorType : this.dataList) {
            this.mapByCode.put(errorType.getCode(), errorType);
        }
    }

    public ValidationErrorType findByCode(String code) {
        ValidationErrorType errorType = this.mapByCode.get(code);
        if (errorType == null) {
            throw new IllegalArgumentException("No data found with code: " + code);
        }
        return errorType;
    }

    public ValidationErrorTypeEnum findEnumByCode(String code) {
        ValidationErrorTypeEnum errorType = this.enumByCode.get(code);
        if (errorType == null) {
            throw new IllegalArgumentException("No data found with code: " + code);
        }
        return errorType;
    }

    private ValidationErrorTypeHolder() {
        Map<String, String> longDescriptions = ValidationErrorTypeHolder.loadDescriptionsFromProperties();
        this.setDataList(Stream.of(ValidationErrorTypeEnum.values()).map(e -> ValidationErrorTypeHolder.createValidationErrorType(e, longDescriptions)).collect(Collectors.toList()));
        Stream.of(ValidationErrorTypeEnum.values()).forEach(e -> this.enumByCode.put(e.getCode(), (ValidationErrorTypeEnum)((Object)e)));
    }

    private static ValidationErrorType createValidationErrorType(ValidationErrorTypeEnum errorTypeEnum, Map<String, String> longDescriptions) {
        ValidationErrorType validationErrorType = new ValidationErrorType();
        validationErrorType.setCode(errorTypeEnum.getCode());
        validationErrorType.setDescription(errorTypeEnum.getDescription());
        validationErrorType.setLongDescription(longDescriptions.get(errorTypeEnum.getCode()));
        validationErrorType.setValidationResultType(errorTypeEnum.getResultType());
        return validationErrorType;
    }

    private static Map<String, String> loadDescriptionsFromProperties() {
        Properties properties = new Properties();
        try {
            properties.load(ValidationErrorTypeHolder.class.getResourceAsStream("/validation_error_descriptions.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load validation_error_descriptions.properties file which is supposed to be in classpath", e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String prefix = "error.code.";
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (!((String)k).startsWith("error.code.")) {
                return;
            }
            String code = ((String)k).substring("error.code.".length());
            result.put(code, (String)v);
        }));
        return result;
    }
}

